﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace AZVIC.Ei8htPOS.WebUI.Admin
{
    public partial class Default : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {

        }

        protected void btnLogin_Click(object sender, EventArgs e)
        {
            string ErrorMsg = "";
            if (txtUsername.Text.Trim().Length != 0)
            {
                if (txtPassword.Text.Trim().Length != 0)
                {
                    UserAccount currentAccount = UserAccountBL.GetItem(Guid.Empty, txtUsername.Text.Trim(), ValidationUtility.EncryptPassword(txtPassword.Text.Trim()), string.Empty, DateTime.MinValue, DateTime.MinValue);
                    if (currentAccount != null && currentAccount.UserRoleType.Trim().ToLower() != "user")
                    {
                        WebSession.CurrentAdminUser = currentAccount;
                        Response.Redirect("~/Admin/Dashboard.aspx", false);
                    }
                    else
                    {
                        ErrorMsg = "Invalid User Name / Password";
                    }
                }
                else
                {
                    ErrorMsg = "Please enter Password";
                }
            }
            else
            {
                ErrorMsg = "Please enter User Name";
            }
            if (!string.IsNullOrEmpty(ErrorMsg))
            {
                ShowMessage(ErrorMsg);
            }
        }

        protected void btnForgetPassword_Click(object sender, EventArgs e)
        {
            string ErrorMsg = "";
            string username = txtFUserName.Text.Trim();

            if (username.Length > 0)
            {
                UserAccount userAcc = UserAccountBL.GetItem(Guid.Empty, username, string.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue);

                if (userAcc != null)
                {
                    if (userAcc.UserRoleType.Trim().ToLower() != "user")
                    {
                        string newPassword = Membership.GeneratePassword(8, 0);
                        userAcc.Mode = GlobalConfigurations.Mode.Update;
                        userAcc.UPassword = ValidationUtility.EncryptPassword(newPassword);
                        UserAccountBL.Save(userAcc);
                        WebSession.SendForgotPasswordEmail(userAcc, newPassword);

                        ErrorMsg = "Account information sent to your email. Please check your email.";
                        txtFUserName.Text = string.Empty;
                        ShowMessage(ErrorMsg);
                    }
                    else
                    {
                        ShowMessage("Username does not exists in the system. Please try again.");
                    }
                }
                else
                {
                    ShowMessage("Username does not exists in the system. Please try again.");
                }
            }
            else
            {
                ShowMessage("Please enter valid Username");
            }
        }

        public void ShowMessage(string Message,string Header="Ei8ht POS - Login")
        {
            ScriptManager.RegisterStartupScript(this, this.GetType(), "Ei8ht POS", "ShowAlert('"+Message+"','"+Header+"');", true);
        }

    }
}